# Karaage Browser Architecture

Karaage Browser is designed to be a lightweight, in-editor inspector tool. It achieves this by combining vanilla web technologies with specific browser capabilities.

## Overall Flow

1. **Host Environment**: Antigravity (VS Code based). The `Simple Browser` extension is used to open `http://localhost:8000/karaage-browser/index.html` inside an editor tab.
2. **Local Server (`Launch_Karaage.ps1`)**: A Python HTTP server (`python -m http.server 8000`) runs in the background. This server is **critical**. Without it, the `<iframe>` would be subject to `file:///` CORS protocol restrictions, which block `contentWindow` access.
3. **The Shell (`index.html`)**: The main user interface of Karaage Browser. Contains:
   - URL Bar (`#url-input`)
   - Navigation Buttons (Back, Forward, Refresh)
   - Inspector Tools Toggle
   - Sidebar Panel (`#side-panel`)
4. **The Target (`#browser-frame`)**: An `<iframe>` element inside the shell. It loads the target HTML files (e.g., `sample.html`).
   
## The Inspector Engine (`script.js`)

When the user clicks the "Inspect Element" button:
1. An invisible `.inspector-overlay` is placed over the `<iframe>`.
2. A `mousemove` event listener tracks the cursor over this overlay.
3. The script accesses the iframe's DOM via `iframe.contentDocument.elementFromPoint(x, y)` to find the exact DOM node the user is hovering over.
4. **Calculations**:
   - Element Dimensions: `getBoundingClientRect()`
   - Margins/Padding: `window.getComputedStyle(el)`
5. **Overlays**: Positioned absolutely over the target, using sizes calculated in step 4.
6. **Code Snippets**: Generates an HTML literal using `outerHTML` (formatted via custom Regex logic) and extracts explicitly styled properties for CSS representation.
