# キーバインド設定ガイド (Keybindings Setup)

Karaage Browser をエディタ（Antigravity）で快適に使うために、キーボードショートカット（キーバインド）を登録する手順です。
HTMLファイルを編集中にショートカットキーを押すだけで、画面の横にブラウザを素早く立ち上げることができます。

## 登録手順

1. **コマンドパレットを開く**
   - Windows/Linux: `Ctrl + Shift + P`
   - macOS: `Cmd + Shift + P`

2. **設定ファイルを開く**
   - コマンドパレットに `keyboard shortcuts json` と入力し、
   - **「基本設定: キーボード ショートカットを開く (JSON)」** （Preferences: Open Keyboard Shortcuts (JSON)）を選択します。

3. **設定を追加する**
   - 開いた `keybindings.json` ファイルの配列（`[` と `]` の間）に、以下の設定を追加します。すでに他の設定がある場合は、一つ前の設定の末尾にカンマ `,` を忘れないようにしてください。

```json
{
    "key": "alt+k",
    "command": "simpleBrowser.show",
    "args": "http://localhost:8000/karaage-browser/index.html",
    "when": "editorTextFocus && editorLangId == 'html'"
}
```

## 設定の解説

- `"key": "alt+k"`: 起動に必要なショートカットキーです。ここでは唐揚げ（Karaage）の「K」を指定していますが、お好みで変更可能です。
- `"command": "simpleBrowser.show"`: エディタ内蔵のシンプルブラウザを起動するコマンドです。
- `"args": "http://localhost:8000/karaage-browser/index.html"`: 開くURLです。必ずローカルサーバー（localhost:8000）を指定します。
- `"when": "editorTextFocus && editorLangId == 'html'"`: このショートカットが有効になる条件です。「現在フォーカスしているファイルがHTMLファイルの時だけ」動作するように制限し、他のファイル編集時の誤爆を防ぎます。

## トラブルシューティング
- **押しても何も起きない**: `when`句の条件を満たしていない（HTMLファイルを開いていない）か、`keybindings.json` の構文エラー（カンマ抜けなど）がないか確認してください。
- **エラー画面になる**: ローカルサーバーが起動していません。`check_env.ps1` を実行（または手動で `python -m http.server 8000` を実行）してからお試しください。
