# 前提条件とインストールガイド

この Skill を使用する前に、以下のソフトウェアがインストールされている必要があります。

## 1. Python (3.9 以上推奨)
アプリケーションの実行に必要です。
- **確認コマンド**: `python --version`
- **インストールされていない場合**:
  - [python.org](https://www.python.org/downloads/) からダウンロードしてインストールしてください。
  - **重要**: インストール時に **"Add Python to PATH"** に必ずチェックを入れてください。

## 2. Google Cloud SDK (gcloud CLI)
Cloud Run へのデプロイに必要です。
- **確認コマンド**: `gcloud --version`
- **インストールされていない場合**:
  - [Google Cloud SDK インストールガイド](https://cloud.google.com/sdk/docs/install) からインストーラをダウンロード。
  - **PowerShell からのインストールコマンド**:
    ```powershell
    (New-Object Net.WebClient).DownloadFile("https://dl.google.com/dl/cloudsdk/channels/rapid/GoogleCloudSDKInstaller.exe", "$env:Temp\GoogleCloudSDKInstaller.exe")
    & $env:Temp\GoogleCloudSDKInstaller.exe
    ```

## 3. gcloud 認証（ユーザー・ADC）
- **ユーザー認証**: `gcloud auth login`
- **アプリ用認証 (ADC)**: ローカルから GCP にアクセスする場合に必要。
  ```powershell
  gcloud auth application-default login
  ```

## 3. pip (Python パッケージマネージャ)
ライブラリのインストールに必要です。通常 Python と一緒にインストールされます。
- **確認コマンド**: `python -m pip --version`
- **失敗する場合**: `python -m ensurepip --upgrade` を試してください。
