# Local Testing Guide (FastAPI)

Cloud Run にデプロイする前に、ローカル PC 上でアプリケーションを動作させる手順です。

## 1. 依存関係のインストール
プロジェクトディレクトリ（`requirements.txt` がある場所）で実行します。
```powershell
python -m pip install -r requirements.txt
```

## 4. リージョン内のサービス一覧取得（導通テスト）
```powershell
gcloud run services list --region=asia-northeast1
```

## トラブルシューティング：デプロイ・認証の失敗
- **"Project not found"**: `gcloud config set project [正しいプロジェクトID]` を確認してください。
- **"401 Unauthorized"**: `gcloud auth login` をやり直してください。
- **"Permission Denied"**: Google Cloud コンソールで自分のアカウントに `Cloud Run 管理者` などの権限があるか確認してください。

## 2. 環境変数の設定 (PowerShell)
API キーや設定値を一時的にセットします。
```powershell
$env:GEMINI_API_KEY = "your-api-key-here"
```

## 3. サーバーの起動
通常は 8000 番ポートを使用します。
```powershell
python -m uvicorn main:app --host 127.0.0.1 --port 8000
```

### トラブルシューティング：よくあるエラー

#### 1. ポート競合 (`[Errno 13] Access denied`)
- **原因**: 他のアプリが同じポートを使用中、またはシステム（Windows）により制限されています。Cloud Run 標準の `8080` は特に競合しやすいです。
- **対策**: **8000** や **8001** など、別の未使用ポートを指定して起動してください。
  ```powershell
  # 8000 番を試す場合
  python -m uvicorn main:app --host 127.0.0.1 --port 8000
  # それでもダメなら 8001 番
  python -m uvicorn main:app --host 127.0.0.1 --port 8001
  ```

#### 2. `ModuleNotFoundError`
- **原因**: ライブラリがインストールされていません。
- **対策**: 手順 1 の `pip install` を再実行してください。

#### 3. APIキーが認識されない
- **原因**: `$env:GEMINI_API_KEY` の設定が現在のターミナルに反映されていません。
- **対策**: `echo $env:GEMINI_API_KEY` で値が表示されるか確認し、空なら再設定してください。
