# Environment Diagnostic Guide

この Skill を開始する際、まずユーザーの環境が「試合に出られる状態か」を確認するための診断手順です。

## 1. Python 環境の確認
監督（Python）の体調と居場所をチェックします。
```powershell
python --version
where.exe python
```

## 2. GCP 接続・認証情報の確認
選手名簿（アカウント）と所属チーム（プロジェクト）をチェックします。
```powershell
gcloud auth list
gcloud config get-value project
```

## 3. 契約・課金状態の確認
球場使用料（課金）が払える状態かチェックします。
```powershell
# プロジェクトが設定されている場合、詳細を表示
gcloud projects describe $(gcloud config get-value project)

# 課金アカウントの紐付け確認
gcloud beta billing projects describe $(gcloud config get-value project)
```

## 4. 実行環境のサマリー取得
OS情報などをまとめて取得します。
```powershell
$PSVersionTable
```
