# Cloud Run Deployment Guide

PowerShell スクリプト (`deploy.ps1`) を使用したデプロイ手順と、直接コマンドを打つ場合の手順です。

## 1. スクリプトによるデプロイ
各プロジェクトフォルダに含まれる `deploy.ps1` を実行します。
```powershell
.\deploy.ps1
```
※事前にスクリプト内の `$GeminiApiKey` または環境変数を設定しておく必要があります。

## 2. gcloud コマンドによる直接デプロイ
ソースからのデプロイ（Dockerfile を使用）を行う場合の基本形です。
```powershell
gcloud run deploy [SERVICE_NAME] `
  --source . `
  --region asia-northeast1 `
  --set-env-vars "GEMINI_API_KEY=[API_KEY]" `
  --allow-unauthenticated
```

- **環境変数の指定**: `--set-env-vars "KEY=VALUE,KEY2=VALUE2"`
- **シークレット (API キー等) の指定**: `--set-env-vars "GEMINI_API_KEY=your_key"`

## 3. デプロイ後の確認とログ
デプロイ完了時に表示される URL にアクセスし、正常にページが表示されるか確認します。

### ログをリアルタイムで確認する
```powershell
gcloud run services logs tail [SERVICE_NAME] --region asia-northeast1
```
