# Tech Briefing 3記事（brief028 / 029 / 030）まとめ

学習目的で参照する、Antigravity と Google Cloud Run の全3回シリーズの要点と、記事更新時のやり取りメモです。

**本番のベースURL（ドメイン）**: `https://yosuke4061.com/`  
記事の例: `https://yosuke4061.com/new_toppage/briefings/brief028/index.html`（第1回）、brief029（第2回）、brief030（第3回）。

## 記事の位置づけ

- **brief028**（第1回・前提条件）: gcloud のインストールと認証。Antigravity の画面・Terminal・LLM 連携の説明。
- **brief029**（第2回・アプリを書く）: main.py / requirements.txt / Dockerfile の3ファイル、cloudrun_hello と cloudrun_ask の2本。ローカルで uvicorn 確認。
- **brief030**（第3回・GCPにデプロイ）: gcloud run deploy、環境変数（GEMINI_API_KEY）、deploy.ps1、デプロイ後の確認（ソース・セキュリティタブ）。

## 記事で押さえたポイント

### Antigravity と Terminal
- SDK（gcloud）はコマンドラインから利用するため、**Antigravity の Terminal** を使う。
- 画面構成: 左＝ディレクトリ構造（cloudrun_hello / cloudrun_ask 等）、中央下＝Terminal、右＝LLM（AI アシスタント）。
- **Terminal 内でテキストを選択**すると、選択範囲の端に「**Chat**」（Ctrl+L でメンション）が出る。選択したログやコマンドを LLM に渡せる（コピペの代わりになる）。

### 認証・一般公開の設定
- **Dockerfile には書かない**。Dockerfile はコンテナの「中身」だけ（ベースイメージ・ファイル・起動コマンド）。
- **deploy.ps1 の `$AllowUnauthenticated`** で決まる。
  - `$true` → `--allow-unauthenticated` → 一般公開（allUsers）。
  - `$false` → `--no-allow-unauthenticated` → 認証が必要。
- 変更例: `$AllowUnauthenticated = $false` に変えてから `.\deploy.ps1` を実行すると認証付きに。
- あとから変える: コンソールの「セキュリティ」タブで「allUsers のアクセス権を削除」または「公開アクセスを許可する」。

### デプロイ後の確認
- **Dockerfile が正しく反映されているか**: コンソールでサービスを開き「**ソース**」タブで main.py / Dockerfile を確認。
- **サービスの情報閲覧**: SDK で UP したあと、同じコンソールのオブザーバビリティ・リビジョン・ソース・**セキュリティ**などのタブで確認可能。
- 「認証が必要」にチェックが入っていても、**allUsers に権限が付与されているとサービスは一般公開**される（--allow-unauthenticated でデプロイした場合）。警告文と「allUsers のアクセス権を削除」で理解・変更できる。

### Python バージョン・サービス YAML
- **Cloud Run のサービス YAML**（Knative Service）には **Python バージョンは書かれていない**。イメージ URI・リソース・ポート・トラフィックなどだけ。
- Python バージョンは **Dockerfile の `FROM`**（例: `python:3.12-slim`）で決まり、そのイメージをビルドした結果が YAML の `containers[].image` になる。
- **デプロイ後に調べる方法**:
  1. **コンソールの「ソース」タブ**: アップロードされた Dockerfile を開いて `FROM` を確認。
  2. **アプリでバージョンを返す**: 例として `/version` で `sys.version` を返しておけば、Service URL にアクセスするだけで確認可能。
  3. ビルドログや Artifact Registry のイメージを直接確認する方法もある。

## ファイル配置の目安

- サンプル: brief029 / brief030 配下に `cloudrun_hello` と `cloudrun_ask` があり、それぞれ main.py, requirements.txt, Dockerfile, deploy.ps1 を置いている。
- 記事内で「ソース」タブや「セキュリティ」タブの説明に使った画像: brief028 は 11.png（Antigravity 全体）, 12.png（Terminal）, 13.png（選択で Chat）；brief030 は 05.png（ソース）, 06.png（セキュリティ）。

## この Skill との対応

- **pre-requisites.md**: brief028 の gcloud インストール・認証と対応。
- **app-structure.md**: brief029 の 3 ファイル・Dockerfile 解説と対応。
- **local-test-guide.md**: brief029 のローカル uvicorn 確認と対応。
- **deploy-guide.md**: brief030 の deploy.ps1 / gcloud run deploy と対応。
- **sdk-verification.md**: brief028 の gcloud コマンド確認と対応。

上記を踏まえ、ユーザーが「記事の内容を確認したい」「デプロイ後の設定を変えたい」「Python バージョンはどこで見るか」などと聞いたときに、このまとめと各 resources を組み合わせて案内する。

## 直近の更新メモ（記事側の変更）

- **日付・更新表示の追加（2026年2月）**
  - brief028 / brief029 / brief030 の各 `index.html` の本文先頭（`<div class="briefing-content">` 直後、免責事項の直前）に、次のブロックを追加済み。
  - 表示内容: 「**2026年2月21日現在の情報**」（1.35rem・太字）と「**21日更新**」（1.15rem・太字）。
  - スタイル: 中央寄せ、薄緑背景（#ecfdf5）・緑枠（#10b981）のボックス。3記事とも同じデザイン・同じ位置。
  - 今後の更新日変更時は、このブロックの文言（日付・「○日更新」）を各3ファイルで揃えて修正する。
