# アプリケーション構成ガイド

Cloud Run にデプロイするために必要な「3種の神器」とその役割を解説します。

## 1. 必須の 3 ファイル
Cloud Run でアプリを動かすには、以下の 3 つを同じディレクトリに用意します。

- **main.py**: アプリケーション本体（FastAPI など）。
- **requirements.txt**: Python ライブラリの一覧（`pip install` 用）。
- **Dockerfile**: コンテナを組み立てる手順書。

## 2. Dockerfile の解説 (Python)
標準的な FastAPI アプリ用の Dockerfile の例と意味です。

```dockerfile
FROM python:3.12-slim
WORKDIR /app
COPY requirements.txt .
RUN pip install --no-cache-dir -r requirements.txt
COPY main.py .
ENV PORT=8080
EXPOSE 8080
CMD exec uvicorn main:app --host 0.0.0.0 --port ${PORT}
```

- **FROM**: 土台にする環境（OS+Python バージョン）。
- **WORKDIR**: コンテナ内の作業ディレクトリ。
- **RUN pip install**: 依存ライブラリのインストール。
- **ENV PORT**: Cloud Run が使用するポート番号。アプリはこの番号でリッスンする必要があります。
- **CMD**: 実行コマンド。`0.0.0.0` で待ち受け、ポートには環境変数 `${PORT}` を使用します。

## 3. コンテナ契約 (PORT)
Cloud Run は起動時に環境変数 `PORT` をコンテナに渡します。
アプリ側は必ずそのポート番号でリクエストを待つように設定してください。
- **FastAPI の例**: `uvicorn main:app --port ${PORT}`
