# Cloud Run デプロイ用 PowerShell スクリプト（cloudrun_hello）
# 使い方: このフォルダで .\deploy.ps1 を実行。事前に gcloud 認証済みであること。
# デフォルトは「個人利用・最小構成」（たまにしかアクセスしない・節約向け）です。

[Console]::OutputEncoding = [System.Text.Encoding]::UTF8
$OutputEncoding = [System.Text.Encoding]::UTF8
if ($Host.UI.RawUI) { chcp 65001 | Out-Null }

# ========== 設定（個人利用・最小構成＝節約向け） ==========
$Region                 = "asia-northeast1"   # リージョン（東京）
$ServiceName            = "cloudrun-hello"   # サービス名
$Project                = ""                 # 空なら gcloud のデフォルトプロジェクトを使用

# 未認証アクセスを許可するか（自分だけ使うなら true で URL を開ける）
$AllowUnauthenticated   = $true

# リソース・スケーリング（たまにしかアクセスしない＝スケールゼロ・最大1で十分）
$Memory                 = "512Mi"            # デフォルトの最小（節約）
$Cpu                    = ""                 # 空でメモリ連動（512Mi なら 1 vCPU 未満）
$MinInstances           = "0"                # 0＝アクセスがなければインスタンスなし（課金ほぼ発生しない）
$MaxInstances           = "1"                # 自分用なら 1 で十分
$Timeout                = "300"               # 5 分（デフォルト）
$Concurrency            = "80"               # デフォルトのまま（1 人なら問題なし）

# ========== ここより下は通常そのままでよい ==========
$ErrorActionPreference  = "Stop"
$scriptDir              = Split-Path -Parent $MyInvocation.MyCommand.Path
Set-Location $scriptDir

$gcloudArgs = @(
    "run", "deploy", $ServiceName,
    "--source", ".",
    "--region", $Region
)
if ($Project)            { $gcloudArgs += "--project"; $gcloudArgs += $Project }
if ($AllowUnauthenticated) { $gcloudArgs += "--allow-unauthenticated" } else { $gcloudArgs += "--no-allow-unauthenticated" }
if ($Memory)             { $gcloudArgs += "--memory"; $gcloudArgs += $Memory }
if ($Cpu)                { $gcloudArgs += "--cpu"; $gcloudArgs += $Cpu }
if ($MinInstances -ne "") { $gcloudArgs += "--min-instances"; $gcloudArgs += $MinInstances }
if ($MaxInstances)       { $gcloudArgs += "--max-instances"; $gcloudArgs += $MaxInstances }
if ($Timeout)            { $gcloudArgs += "--timeout"; $gcloudArgs += $Timeout }
if ($Concurrency)        { $gcloudArgs += "--concurrency"; $gcloudArgs += $Concurrency }

Write-Host "Deploying to Cloud Run: $ServiceName (region: $Region)" -ForegroundColor Cyan
& gcloud @gcloudArgs
